### MaskCrypt

MaskCrypt is a secure federated learning system based on homomorphic encryption. Instead of encrypting all the model updates, MaskCrypt encrypts only a subset of them to balance the tradeoff between security and efficiency. In this example, clients only select 5% of the model updates to encrypt during the learning process. The number of encrypted weights is determined by `encrypt_ratio`, which can be adjusted in the configuration file. A random mask will be adopted if `random_mask` is set to `true`.

```bash
cd examples/secure_aggregation/maskcrypt
uv run maskcrypt.py -c maskcrypt_MNIST_lenet5.yml
```
